# Copyright 2022 Wireflow AB

# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

# 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

# 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

# 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import wf_usb_programmable_resistor

#initialization of the device
#the input of the initialization is portname and slave address
wf214x=wf_usb_programmable_resistor.ProgrammableResistor('COM0')

#the get_serial_number() function returns the serial number of the device
#it has no arguments as inputs
sernum=wf214x.get_serial_number()
print("Serial number:    "+str(sernum))

#the get_device_type() function returns the device type(1 or 2)
#it has no arguments as inputs
device=wf214x.get_device_type()
print("Device type:      "+str(device))

#the get_firmware_version() function returns the firmware info of the device
#it has no arguments as inputs
version=wf214x.get_firmware_version()
print("Firmware version: "+version)

#the get_calibration_date() function returns the calibration date of the device(year-month-day)
#it has no arguments as inputs
cal=wf214x.get_calibration_date()
print("Calibration:      "+cal)

# If device has only one channel
if (device==0):
    setpoint = 20.0
    print("Device has one channel")
    
    #set_resistance_one_chan() allows us to write to only one channel at a time
    #it takes as input the channel number and the value that we want to set
    wf214x.set_resistance_one_chan(0,setpoint)
    print("Set resistance:    "+str(setpoint))

    #reads the value saved in the sprecified channel
    #it takes as input the channel number that we want to know its value
    #it returns a nubmer as the output
    resistance_value=wf214x.get_resistance_output_one_chan(0)
    print("Output resistance: "+str(resistance_value))

# If device has four channels
if (device==1):
    print("Device has four channels (this example uses channel 2 and 3 in series in enhanced mode)")
    setpoint_0 = 100.0 
    setpoint_1 = 5000.0

    #set_resistance_four_chan() allows us to write at all the 4 channels directly
    #it takes as input the values that we want to set to each channel as list
    setpoints = [setpoint_0,setpoint_1,106,106]
    wf214x.set_resistance_four_chan(setpoints)
    print("Set resistance 0:      "+str(setpoints[0]))
    print("Set resistance 1:      "+str(setpoints[1]))

    #set_resistance_one_chan_enhanced() allows us to write higher values of resistance
    #it takes as input the channel groups that we want to write at('0-1' or '2-3') and the value
    setpoint_enh = 20000.0
    wf214x.set_resistance_one_chan_enhanced('2-3',setpoint_enh)
    print("Set resistance 2-3:    "+str(setpoint_enh))
    
    #reads the values saved in all four channels
    #it returns an array with 4(four) values corresponding to each of the 4(four) channels
    resistances=wf214x.get_resistance_output_four_chan()
    for i in range(0,4):
        print("Output resistance "+str(i)+":   "+ str(resistances[i]))
    print("Output resistance 2-3: "+ str(resistances[2]+resistances[3]))
    

#clear() function it closes the serial port communication
#it takes no arguments as input
wf214x.clear()
